"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.App = void 0;
const dotenv = __importStar(require("dotenv"));
dotenv.config();
const express_1 = __importDefault(require("express"));
const body_parser_1 = __importDefault(require("body-parser"));
const cors_1 = __importDefault(require("cors"));
const swagger_ui_express_1 = __importDefault(require("swagger-ui-express"));
const routes_1 = require("./routes");
const datasource_plugin_1 = require("./plugins/datasource.plugin");
const httpLogger_1 = require("./loggers/httpLogger");
const app_config_1 = require("./configs/app.config");
const errorLogger_middleware_1 = require("./middlewares/errorLogger.middleware");
const errorHandler_middleware_1 = require("./middlewares/errorHandler.middleware");
const invalidPath_middleware_1 = require("./middlewares/invalidPath.middleware");
const docs_1 = require("./docs");
const path_1 = __importDefault(require("path"));
/**
 * * initiate express and express community middleware
 */
const { baseRoute, environment } = app_config_1.AppConfig;
const app = (0, express_1.default)();
app.use(httpLogger_1.HttpLogger);
app.use(express_1.default.json());
app.use(body_parser_1.default.urlencoded({
    extended: true,
}));
app.use(body_parser_1.default.json({ limit: "1mb" }));
app.use(body_parser_1.default.urlencoded({ limit: "1mb", extended: true }));
app.use((0, cors_1.default)());
/* serve static assets */
app.use(express_1.default.static(path_1.default.join(__dirname, "../../../public")));
/**
 * * Initialize database connection
 */
(0, datasource_plugin_1.InitiateRwwsDataSourcePluginConnection)();
/**
 * * A basic health check route above all the routes for checking if the application is running
 */
app.get(`${baseRoute}/health`, (req, res) => {
    res.status(200).json({
        message: "Basic Health Check.",
        environment: process.env.NODE_ENV,
    });
});
/**
 * * Route injection to the app module
 */
app.use(`${baseRoute}/auth`, routes_1.AuthRoutes);
app.use(`${baseRoute}/news`, routes_1.NewsRoutes);
app.use(`${baseRoute}/story`, routes_1.StoryRoutes);
app.use(`${baseRoute}/program`, routes_1.ProgramRoutes);
/**
 * * Route injection for swagger documentation
 */
app.use("/v1/docs", swagger_ui_express_1.default.serve, swagger_ui_express_1.default.setup(docs_1.docs));
/**
 * * Error logger middleware
 * * Error handler middleware
 * * Invalid Path middleware
 */
app.use(invalidPath_middleware_1.InvalidPath);
app.use(errorHandler_middleware_1.ErrorHandler);
app.use(errorLogger_middleware_1.ErrorLogger);
exports.App = app;
//# sourceMappingURL=app.js.map