"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewsDAO = void 0;
const news_repository_1 = require("../repositories/news.repository");
class NewsDAO {
    constructor() {
        this.newsRepo = news_repository_1.NewsRepository;
    }
    findOneById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.newsRepo
                .createQueryBuilder("news")
                .leftJoinAndSelect("news.category", "category")
                .leftJoinAndSelect("news.createdBy", "createdBy")
                .where("news.id = :id", { id })
                .getOne();
        });
    }
    save(news) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.newsRepo.save(news);
        });
    }
}
exports.NewsDAO = NewsDAO;
//# sourceMappingURL=news.dao.js.map