"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProgramDAO = void 0;
const program_repository_1 = require("../repositories/program.repository");
class ProgramDAO {
    constructor() {
        this.programRepo = program_repository_1.ProgramRepository;
    }
    findOneById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.programRepo
                .createQueryBuilder("program")
                .leftJoinAndSelect("program.category", "category")
                .leftJoinAndSelect("program.goals", "goals")
                .leftJoinAndSelect("program.achievements", "achievements")
                .leftJoinAndSelect("program.locations", "locations")
                .where("program.id = :id", { id })
                .getOne();
        });
    }
    save(program) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.programRepo.save(program);
        });
    }
}
exports.ProgramDAO = ProgramDAO;
//# sourceMappingURL=program.dao.js.map