"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoryDAO = void 0;
const story_repository_1 = require("../repositories/story.repository");
class StoryDAO {
    constructor() {
        this.storyRepo = story_repository_1.StoryRepository;
    }
    findOneById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.storyRepo
                .createQueryBuilder("story")
                .leftJoinAndSelect("story.category", "category")
                .leftJoinAndSelect("story.createdBy", "createdBy")
                .where("story.id = :id", { id })
                .getOne();
        });
    }
    save(story) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.storyRepo.save(story);
        });
    }
}
exports.StoryDAO = StoryDAO;
//# sourceMappingURL=story.dao.js.map