"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserDAO = void 0;
const user_repository_1 = require("../repositories/user.repository");
class UserDAO {
    constructor() {
        this.userRepository = user_repository_1.UserRepository;
    }
    findOneById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.userRepository.findOneBy({
                id: id,
            });
        });
    }
    save(user) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.userRepository.save(user);
        });
    }
    findOneByEmail(email) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield this.userRepository.findOneBy({
                email: email,
            });
        });
    }
}
exports.UserDAO = UserDAO;
//# sourceMappingURL=user.dao.js.map