"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RwwsDataSource = void 0;
const db_config_1 = require("./../configs/db.config");
const typeorm_1 = require("typeorm");
const user_entity_1 = require("../entities/user.entity");
const news_entity_1 = require("../entities/news.entity");
const category_entity_1 = require("../entities/category.entity");
const story_entity_1 = require("../entities/story.entity");
const program_entity_1 = require("../entities/program.entity");
const programLocation_entity_1 = require("../entities/programLocation.entity");
const programGoal_entity_1 = require("../entities/programGoal.entity");
const programAchievement_entity_1 = require("../entities/programAchievement.entity");
exports.RwwsDataSource = new typeorm_1.DataSource({
    type: "mysql",
    host: db_config_1.RwwsDBConfig.host,
    port: db_config_1.RwwsDBConfig.port,
    driver: require("mysql2"),
    username: db_config_1.RwwsDBConfig.username,
    password: db_config_1.RwwsDBConfig.password,
    database: db_config_1.RwwsDBConfig.database,
    synchronize: db_config_1.RwwsDBConfig.synchronize,
    logging: db_config_1.RwwsDBConfig.logging,
    entities: [
        user_entity_1.User,
        news_entity_1.News,
        category_entity_1.Category,
        story_entity_1.Story,
        program_entity_1.Program,
        programLocation_entity_1.ProgramLocation,
        programGoal_entity_1.ProgramGoal,
        programAchievement_entity_1.ProgramAchievement,
    ],
    ssl: {
        rejectUnauthorized: false, // Set to true if you have a trusted certificate
    },
});
//# sourceMappingURL=app.datasources.js.map