"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProgramDTO = void 0;
class ProgramDTO {
    constructor(program) {
        var _a, _b, _c;
        this.id = program.id;
        this.category_id = program.category.id;
        this.category_name = program.category.name;
        this.title = program.title;
        this.description = program.description;
        this.longDescription = program.longDescription;
        this.image = program.image;
        this.video = program.video;
        this.goals = ((_a = program.goals) === null || _a === void 0 ? void 0 : _a.map(goal => goal.goal)) || [];
        this.locations = ((_b = program.locations) === null || _b === void 0 ? void 0 : _b.map(location => location.location)) || [];
        this.achievements = ((_c = program.achievements) === null || _c === void 0 ? void 0 : _c.map(achievement => achievement.achievement)) || [];
        this.status = program.status;
        this.start_date = program.start_date;
        this.created_at = program.created_at;
        this.updated_at = program.updated_at;
    }
}
exports.ProgramDTO = ProgramDTO;
//# sourceMappingURL=program.dto.js.map