"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoryDTO = void 0;
class StoryDTO {
    constructor(story) {
        this.id = story.id;
        this.category_id = story.category.id;
        this.category_name = story.category.name;
        this.title = story.title;
        this.excerpt = story.excerpt;
        this.content = story.content;
        this.image = story.image;
        this.video = story.video;
        this.location = story.location;
        this.created_by = story.createdBy ? story.createdBy.username : "";
        this.created_at = story.created_at;
        this.updated_at = story.updated_at;
    }
}
exports.StoryDTO = StoryDTO;
//# sourceMappingURL=story.dto.js.map