"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Program = void 0;
const typeorm_1 = require("typeorm");
const category_entity_1 = require("./category.entity");
const programGoal_entity_1 = require("./programGoal.entity");
const programLocation_entity_1 = require("./programLocation.entity");
const programAchievement_entity_1 = require("./programAchievement.entity");
const programStatus_enum_1 = require("../enums/programStatus.enum");
let Program = class Program {
};
exports.Program = Program;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    __metadata("design:type", typeof BigInt === "function" ? BigInt : Object)
], Program.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "varchar", length: "255" }),
    __metadata("design:type", String)
], Program.prototype, "title", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "varchar", length: "400" }),
    __metadata("design:type", String)
], Program.prototype, "description", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "text" }),
    __metadata("design:type", String)
], Program.prototype, "longDescription", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(type => category_entity_1.Category),
    (0, typeorm_1.JoinColumn)({ name: "category_id" }),
    __metadata("design:type", category_entity_1.Category)
], Program.prototype, "category", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => programGoal_entity_1.ProgramGoal, goal => goal.program, { cascade: true }),
    __metadata("design:type", Array)
], Program.prototype, "goals", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => programLocation_entity_1.ProgramLocation, location => location.program, { cascade: true }),
    __metadata("design:type", Array)
], Program.prototype, "locations", void 0);
__decorate([
    (0, typeorm_1.OneToMany)(() => programAchievement_entity_1.ProgramAchievement, achievement => achievement.program, { cascade: true }),
    __metadata("design:type", Array)
], Program.prototype, "achievements", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "enum", enum: programStatus_enum_1.ProgramStatus, default: programStatus_enum_1.ProgramStatus.ONGOING }),
    __metadata("design:type", String)
], Program.prototype, "status", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "varchar", length: 500, nullable: true }),
    __metadata("design:type", String)
], Program.prototype, "image", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: "varchar", length: 500, nullable: true }),
    __metadata("design:type", String)
], Program.prototype, "video", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: Date, nullable: true }),
    __metadata("design:type", Object)
], Program.prototype, "start_date", void 0);
__decorate([
    (0, typeorm_1.CreateDateColumn)(),
    __metadata("design:type", Date)
], Program.prototype, "created_at", void 0);
__decorate([
    (0, typeorm_1.UpdateDateColumn)(),
    __metadata("design:type", Date)
], Program.prototype, "updated_at", void 0);
exports.Program = Program = __decorate([
    (0, typeorm_1.Entity)()
], Program);
//# sourceMappingURL=program.entity.js.map