"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BadGatewayError = void 0;
const httpStatusCode_enum_1 = require("../enums/httpStatusCode.enum");
const base_error_1 = require("./base.error");
class BadGatewayError extends base_error_1.BaseError {
    constructor(origin, message, code) {
        const errorArg = {
            origin: origin,
            message: message,
            code: code,
            statusCode: httpStatusCode_enum_1.HttpStatusCode.BAD_GATEWAY,
            isOperational: true,
        };
        super(errorArg);
    }
}
exports.BadGatewayError = BadGatewayError;
//# sourceMappingURL=badGetway.error.js.map