"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BadRequestError = void 0;
const httpStatusCode_enum_1 = require("../enums/httpStatusCode.enum");
const base_error_1 = require("./base.error");
class BadRequestError extends base_error_1.BaseError {
    constructor(origin, message, code) {
        const errorArg = {
            origin: origin,
            message: message,
            code: code,
            statusCode: httpStatusCode_enum_1.HttpStatusCode.BAD_REQUEST,
            isOperational: true,
        };
        super(errorArg);
    }
}
exports.BadRequestError = BadRequestError;
//# sourceMappingURL=badRequest.error.js.map