"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseError = void 0;
class BaseError extends Error {
    constructor(errorArg) {
        super(errorArg.message);
        Object.setPrototypeOf(this, new.target.prototype);
        this.origin = errorArg.origin;
        this.message = errorArg.message;
        this.code = errorArg.code;
        this.statusCode = errorArg.statusCode;
        this.isOperational = errorArg.isOperational;
        Error.captureStackTrace(this);
    }
}
exports.BaseError = BaseError;
//# sourceMappingURL=base.error.js.map