"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceUnavailableError = void 0;
const httpStatusCode_enum_1 = require("../enums/httpStatusCode.enum");
const base_error_1 = require("./base.error");
class ServiceUnavailableError extends base_error_1.BaseError {
    constructor(origin, message, code) {
        const errorArg = {
            origin: origin,
            message: message,
            code: code,
            statusCode: httpStatusCode_enum_1.HttpStatusCode.SERVICE_UNAVAILABLE,
            isOperational: true,
        };
        super(errorArg);
    }
}
exports.ServiceUnavailableError = ServiceUnavailableError;
//# sourceMappingURL=serviceUnavailable.error.js.map