"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TooManyRequestsError = void 0;
const httpStatusCode_enum_1 = require("../enums/httpStatusCode.enum");
const base_error_1 = require("./base.error");
class TooManyRequestsError extends base_error_1.BaseError {
    constructor(origin, message, code) {
        const errorArg = {
            origin: origin,
            message: message,
            code: code,
            statusCode: httpStatusCode_enum_1.HttpStatusCode.TOO_MANY_REQUESTS,
            isOperational: true,
        };
        super(errorArg);
    }
}
exports.TooManyRequestsError = TooManyRequestsError;
//# sourceMappingURL=tooManyRequest.error.js.map