"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnprocessableEntityError = void 0;
const httpStatusCode_enum_1 = require("../enums/httpStatusCode.enum");
const base_error_1 = require("./base.error");
class UnprocessableEntityError extends base_error_1.BaseError {
    constructor(origin, message, code) {
        const errorArg = {
            origin: origin,
            message: message,
            code: code,
            statusCode: httpStatusCode_enum_1.HttpStatusCode.UNPROCESSABLE_ENTITY,
            isOperational: true,
        };
        super(errorArg);
    }
}
exports.UnprocessableEntityError = UnprocessableEntityError;
//# sourceMappingURL=unprocessableEntity.error.js.map