"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.tokenGenerator = void 0;
const jwt = __importStar(require("jsonwebtoken"));
const internalServer_error_1 = require("../errors/internalServer.error");
const app_config_1 = require("../configs/app.config");
const tokenGenerator = (user) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const accessToken = jwt.sign({
            id: user.id,
            type: "access",
            payload: "",
        }, app_config_1.AppConfig.jwtSecret, {
        // expiresIn: '1m'
        });
        const refreshToken = jwt.sign({
            id: user.id,
            type: "refresh",
            payload: "",
        }, app_config_1.AppConfig.jwtSecret, {
        // expiresIn: '7d'
        });
        return {
            success: true,
            message: "Token generated successfully",
            data: {
                access_token: accessToken,
                refresh_token: refreshToken,
            },
        };
    }
    catch (error) {
        throw new internalServer_error_1.InternalServerError("token-generation-failed", "Token generation failed", 3000);
    }
});
exports.tokenGenerator = tokenGenerator;
//# sourceMappingURL=tokenGenerator.helper.js.map