"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLogger = void 0;
/**
 * * HTTP request logger. this logger will log every request ever made to your api
 * * with the time of the request, method, status, url, responseContentLength and responseTime
 * * this middleware is injected at the main app.js
 * * app.use(httpLogger)
 */
const morgan_1 = __importDefault(require("morgan"));
const logger_1 = require("../loggers/logger");
const format = {
    method: ":method",
    url: ":url",
    status: ":status",
    resContentLength: ":res[content-length]",
    responseTime: ":response-time",
};
exports.HttpLogger = (0, morgan_1.default)(JSON.stringify(format), {
    stream: {
        write: (message) => {
            const { method, url, status, resContentLength, responseTime } = JSON.parse(message);
            if (url !== "/v1/health")
                logger_1.Logger.info("HTTP-Request-Log", {
                    timestamp: new Date(),
                    method,
                    url,
                    status: Number(status),
                    responseTime: Number(responseTime),
                    resContentLength,
                });
        },
    },
});
//# sourceMappingURL=httpLogger.js.map