"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Logger = void 0;
/**
 * * import necessary modules for winston logger
 */
const winston_1 = require("winston");
const { combine, timestamp, splat, json } = winston_1.format;
/**
 * * transporter options for console transporter (no file writing)
 */
const transporterOptions = {
    console: {
        level: process.env.NODE_ENV === "production" ? "info" : "debug", // Use "info" for production, "debug" for development
        handleExceptions: true,
        json: true,
        colorize: true,
    },
};
/**
 * * base logger using winston.createLogger
 * * logs are only written to the console (stdout)
 */
const logger = (0, winston_1.createLogger)({
    levels: winston_1.config.npm.levels,
    format: combine(timestamp(), splat(), json()),
    transports: [
        new winston_1.transports.Console(transporterOptions.console), // Only console logging
    ],
    exitOnError: false,
});
exports.Logger = logger;
//# sourceMappingURL=logger.js.map