"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ErrorHandler = void 0;
const ErrorHandler = (error, req, res, next) => {
    const errorStatus = error.statusCode || 500;
    const errorMessage = error.message || "Oops! something went wrong";
    const customErrorCode = error.code || 1000;
    return res.status(errorStatus).json({
        success: false,
        message: errorMessage,
        code: customErrorCode,
        data: {},
    });
};
exports.ErrorHandler = ErrorHandler;
//# sourceMappingURL=errorHandler.middleware.js.map