"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValidateResetPasswordRequestBody = void 0;
const logger_1 = require("../loggers/logger");
const badRequest_error_1 = require("../errors/badRequest.error");
const authRequestBody_validator_1 = require("../validators/authRequestBody.validator");
const ValidateResetPasswordRequestBody = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        logger_1.Logger.debug("reset-password-request-body: %s", req.body);
        const result = yield authRequestBody_validator_1.ResetPasswordRequestBody.validateAsync(req.body);
        logger_1.Logger.debug("reset-password-request-body-validation-result: %s", result);
        next();
    }
    catch (error) {
        const origin = error.origin
            ? error.origin
            : "ValidateResetPasswordRequestBody-base-error";
        const code = error.code ? error.code : 3000;
        const message = error.message
            ? error.message
            : "`Any of these fields {token, new password} not provided or in incorrect format. ${error.details[0].message}`";
        error = new badRequest_error_1.BadRequestError(origin, message, code);
        next(error);
    }
});
exports.ValidateResetPasswordRequestBody = ValidateResetPasswordRequestBody;
//# sourceMappingURL=validateResetPasswordRequestBody.middleware.js.map