"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValidateCreateStoryRequestBody = void 0;
const logger_1 = require("../loggers/logger");
const badRequest_error_1 = require("../errors/badRequest.error");
const storyRequestBody_validator_1 = require("../validators/storyRequestBody.validator");
const ValidateCreateStoryRequestBody = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        const reqBodyFromFormData = JSON.parse(req.body.jsonData);
        logger_1.Logger.debug("story-create-request-body: %s", reqBodyFromFormData);
        const result = yield storyRequestBody_validator_1.CreateStoryRequestBody.validateAsync(reqBodyFromFormData);
        logger_1.Logger.debug("story-create-request-body-validation-result: %s", result);
        res.locals.reqBody = result;
        next();
    }
    catch (error) {
        const origin = error.origin ? error.origin : "ValidateCreateStoryRequestBody-base-error";
        const code = error.code ? error.code : 3000;
        const message = error.message
            ? error.message
            : "`Any of these fields {title, excerpt, content, category, location} not provided or in incorrect format. ${error.details[0].message}`";
        error = new badRequest_error_1.BadRequestError(origin, message, code);
        next(error);
    }
});
exports.ValidateCreateStoryRequestBody = ValidateCreateStoryRequestBody;
//# sourceMappingURL=validateStoryRequestBody.middleware.js.map