"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VerifyJwtToken = void 0;
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const unauthorized_error_1 = require("../errors/unauthorized.error");
const app_config_1 = require("../configs/app.config");
const user_dao_1 = require("../dao/user.dao");
// Middleware to verify JWT token
const VerifyJwtToken = (req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    try {
        // Extract token from the Authorization header
        const authHeader = req.headers.authorization;
        if (!authHeader || !authHeader.startsWith("Bearer ")) {
            throw new unauthorized_error_1.UnauthorizedError("token-missing", "Authorization token is missing", 4001);
        }
        const token = authHeader.split(" ")[1]; // Get the actual token after "Bearer"
        // Verify token using jwt.verify
        const decodedToken = jsonwebtoken_1.default.verify(token, app_config_1.AppConfig.jwtSecret);
        res.locals.userId = decodedToken.id;
        const user = yield new user_dao_1.UserDAO().findOneById(res.locals.userId);
        if (!user) {
            throw new unauthorized_error_1.UnauthorizedError("VerifyJwtToken-check-user", "Malformed token or user does not exist", 4005);
        }
        res.locals.user = user;
        next(); // Proceed to the next middleware or route handler
    }
    catch (error) {
        // Handle token errors (invalid token, expired token, etc.)
        if (error.name === "TokenExpiredError") {
            next(new unauthorized_error_1.UnauthorizedError("token-expired", "JWT token has expired", 4002));
        }
        else if (error.name === "JsonWebTokenError") {
            next(new unauthorized_error_1.UnauthorizedError("token-invalid", "Invalid JWT token", 4003));
        }
        else {
            next(new unauthorized_error_1.UnauthorizedError("token-verification-failed", "Token verification failed", 4004));
        }
    }
});
exports.VerifyJwtToken = VerifyJwtToken;
//# sourceMappingURL=verifyJwtToken.middleware.js.map