"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DestroyRwwsDataSourcePluginConnection = exports.InitiateRwwsDataSourcePluginConnection = void 0;
const app_datasources_1 = require("../datasources/app.datasources");
const logger_1 = require("../loggers/logger");
const rwwsDataSourceInitiatedSuccessCallback = () => {
    logger_1.Logger.debug("rwws-data-source-init-success: %s", "Rwws data Source initiation success");
};
const rwwsDataSourceInitiatedErrorCallback = (err) => {
    logger_1.Logger.error("rwws-data-source-init-error:", err);
    (0, exports.DestroyRwwsDataSourcePluginConnection)();
    process.exit(0);
};
const rwwsDataSourceDestroyedSuccessCallback = () => {
    logger_1.Logger.debug("rwws-data-source-destroy-success: %s", "Rwws data Source destroy success");
};
const rwwsDataSourceDestroyedErrorCallback = (err) => {
    logger_1.Logger.error("rwws-data-source-destroy-error:", err);
};
const InitiateRwwsDataSourcePluginConnection = () => {
    if (!app_datasources_1.RwwsDataSource.isInitialized) {
        app_datasources_1.RwwsDataSource.initialize()
            .then(() => __awaiter(void 0, void 0, void 0, function* () {
            yield app_datasources_1.RwwsDataSource.runMigrations();
            rwwsDataSourceInitiatedSuccessCallback();
        }))
            .catch(rwwsDataSourceInitiatedErrorCallback);
    }
};
exports.InitiateRwwsDataSourcePluginConnection = InitiateRwwsDataSourcePluginConnection;
const DestroyRwwsDataSourcePluginConnection = () => {
    if (app_datasources_1.RwwsDataSource.isInitialized) {
        logger_1.Logger.debug("Destroying rwws-data-source plugin connection...");
        app_datasources_1.RwwsDataSource.destroy()
            .then(rwwsDataSourceDestroyedSuccessCallback)
            .catch(rwwsDataSourceDestroyedErrorCallback);
    }
};
exports.DestroyRwwsDataSourcePluginConnection = DestroyRwwsDataSourcePluginConnection;
//# sourceMappingURL=datasource.plugin.js.map