"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthRouter = void 0;
const express_1 = require("express");
const auth_controller_1 = require("../controllers/auth.controller");
const validateSignInRequestBody_middleware_1 = require("../middlewares/validateSignInRequestBody.middleware");
const verifyJwtToken_middleware_1 = require("../middlewares/verifyJwtToken.middleware");
const validateChangePasswordRequestBody_middleware_1 = require("../middlewares/validateChangePasswordRequestBody.middleware");
const validateForgotPasswordRequestBody_middleware_1 = require("../middlewares/validateForgotPasswordRequestBody.middleware");
const validateSignupRequestBody_middleware_1 = require("../middlewares/validateSignupRequestBody.middleware");
const validateResetPasswordRequestBody_middleware_1 = require("../middlewares/validateResetPasswordRequestBody.middleware");
const authRouter = (0, express_1.Router)();
/**
 * * user sign up route
 */
authRouter.post("/signup", [validateSignupRequestBody_middleware_1.ValidateSignUpRequestBody], auth_controller_1.authController.signUp);
/**
 * * user sign in route
 */
authRouter.post("/signin", [validateSignInRequestBody_middleware_1.ValidateSignInRequestBody], auth_controller_1.authController.signIn);
/**
 * * user change password route (requires JWT token)
 */
authRouter.post("/change-password", [verifyJwtToken_middleware_1.VerifyJwtToken], [validateChangePasswordRequestBody_middleware_1.ValidateChangePasswordRequestBody], auth_controller_1.authController.changePassword);
/**
 * * user forgot password route
 */
authRouter.post("/forgot-password", [validateForgotPasswordRequestBody_middleware_1.ValidateForgotPasswordRequestBody], auth_controller_1.authController.forgotPassword);
/**
 * * user reset password route
 */
authRouter.post("/reset-password", [validateResetPasswordRequestBody_middleware_1.ValidateResetPasswordRequestBody], auth_controller_1.authController.resetPassword);
exports.AuthRouter = authRouter;
//# sourceMappingURL=auth.routes.js.map