"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NewsRouter = void 0;
const express_1 = require("express");
const news_controller_1 = require("../controllers/news.controller");
const upload_plugin_1 = require("../plugins/upload.plugin");
const validateNewsRequestBody_middleware_1 = require("../middlewares/validateNewsRequestBody.middleware");
const verifyJwtToken_middleware_1 = require("../middlewares/verifyJwtToken.middleware");
const newsRouter = (0, express_1.Router)();
newsRouter.get("/", news_controller_1.newsController.getAll);
newsRouter.post("/", [verifyJwtToken_middleware_1.VerifyJwtToken, upload_plugin_1.Upload.single("image"), validateNewsRequestBody_middleware_1.ValidateCreateNewsRequestBody], news_controller_1.newsController.createOne);
newsRouter.put("/:newsId", [verifyJwtToken_middleware_1.VerifyJwtToken, upload_plugin_1.Upload.single("image"), validateNewsRequestBody_middleware_1.ValidateCreateNewsRequestBody], news_controller_1.newsController.updateOne);
newsRouter.get("/:newsId", news_controller_1.newsController.getOne);
newsRouter.delete("/:newsId", verifyJwtToken_middleware_1.VerifyJwtToken, news_controller_1.newsController.deleteOne);
exports.NewsRouter = newsRouter;
//# sourceMappingURL=news.routes.js.map