"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProgramRouter = void 0;
const express_1 = require("express");
const upload_plugin_1 = require("../plugins/upload.plugin");
const verifyJwtToken_middleware_1 = require("../middlewares/verifyJwtToken.middleware");
const program_controller_1 = require("../controllers/program.controller");
const validateProgramRequestBody_middleware_copy_1 = require("../middlewares/validateProgramRequestBody.middleware copy");
const programRouter = (0, express_1.Router)();
programRouter.get("/", program_controller_1.programController.getAll);
programRouter.get("/:programId", program_controller_1.programController.getOne);
programRouter.post("/", [verifyJwtToken_middleware_1.VerifyJwtToken, upload_plugin_1.Upload.single("image"), validateProgramRequestBody_middleware_copy_1.ValidateCreateProgramRequestBody], program_controller_1.programController.createOne);
programRouter.put("/:programId", [verifyJwtToken_middleware_1.VerifyJwtToken, upload_plugin_1.Upload.single("image"), validateProgramRequestBody_middleware_copy_1.ValidateCreateProgramRequestBody], program_controller_1.programController.updateOne);
programRouter.delete("/:programId", verifyJwtToken_middleware_1.VerifyJwtToken, program_controller_1.programController.deleteOne);
exports.ProgramRouter = programRouter;
//# sourceMappingURL=program.routes.js.map