"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoryRouter = void 0;
const express_1 = require("express");
const upload_plugin_1 = require("../plugins/upload.plugin");
const verifyJwtToken_middleware_1 = require("../middlewares/verifyJwtToken.middleware");
const story_controller_1 = require("../controllers/story.controller");
const validateStoryRequestBody_middleware_1 = require("../middlewares/validateStoryRequestBody.middleware");
const storyRouter = (0, express_1.Router)();
storyRouter.get("/", story_controller_1.storyController.getAll);
storyRouter.get("/:storyId", story_controller_1.storyController.getOne);
storyRouter.post("/", [verifyJwtToken_middleware_1.VerifyJwtToken, upload_plugin_1.Upload.single("image"), validateStoryRequestBody_middleware_1.ValidateCreateStoryRequestBody], story_controller_1.storyController.createOne);
storyRouter.put("/:storyId", [verifyJwtToken_middleware_1.VerifyJwtToken, upload_plugin_1.Upload.single("image"), validateStoryRequestBody_middleware_1.ValidateCreateStoryRequestBody], story_controller_1.storyController.updateOne);
storyRouter.delete("/:storyId", verifyJwtToken_middleware_1.VerifyJwtToken, story_controller_1.storyController.deleteOne);
exports.StoryRouter = storyRouter;
//# sourceMappingURL=story.routes.js.map