"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateUpdatedNewsEntityObject = exports.generateNewsEntityObject = void 0;
const news_entity_1 = require("../entities/news.entity");
const categoryType_enum_1 = require("../enums/categoryType.enum");
const badRequest_error_1 = require("../errors/badRequest.error");
const category_repository_1 = require("../repositories/category.repository");
const generateNewsEntityObject = (requestBodyObj) => __awaiter(void 0, void 0, void 0, function* () {
    const category = yield category_repository_1.CategoryRepository.findOneBy({
        id: requestBodyObj.category_id,
        type: categoryType_enum_1.CategoryType.NEWS,
    });
    if (!category) {
        throw new badRequest_error_1.BadRequestError("generateNewsEntityObject-for-create-news", "News category not found", 3015);
    }
    const news = new news_entity_1.News();
    news.title = requestBodyObj.title;
    news.excerpt = requestBodyObj.excerpt;
    news.image = requestBodyObj.image;
    news.video = requestBodyObj.video;
    news.createdBy = requestBodyObj.current_user;
    news.category = category;
    return news;
});
exports.generateNewsEntityObject = generateNewsEntityObject;
const generateUpdatedNewsEntityObject = (updatedRequestBody, news) => __awaiter(void 0, void 0, void 0, function* () {
    const category = yield category_repository_1.CategoryRepository.findOneBy({
        id: updatedRequestBody.category_id,
        type: categoryType_enum_1.CategoryType.NEWS,
    });
    if (!category) {
        throw new badRequest_error_1.BadRequestError("generateNewsEntityObject-for-create-news", "News category not found", 3015);
    }
    news.title = updatedRequestBody.title;
    news.excerpt = updatedRequestBody.excerpt;
    news.image = updatedRequestBody.image;
    news.video = updatedRequestBody.video;
    news.category = category;
    return news;
});
exports.generateUpdatedNewsEntityObject = generateUpdatedNewsEntityObject;
//# sourceMappingURL=news.utility.js.map