"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateUpdateProgramEntityObject = exports.generateProgramEntityObject = void 0;
const program_entity_1 = require("../entities/program.entity");
const programAchievement_entity_1 = require("../entities/programAchievement.entity");
const programGoal_entity_1 = require("../entities/programGoal.entity");
const programLocation_entity_1 = require("../entities/programLocation.entity");
const categoryType_enum_1 = require("../enums/categoryType.enum");
const badRequest_error_1 = require("../errors/badRequest.error");
const category_repository_1 = require("../repositories/category.repository");
const programAchievement_repository_1 = require("../repositories/programAchievement.repository");
const programGoal_repository_1 = require("../repositories/programGoal.repository");
const programLocation_repository_1 = require("../repositories/programLocation.repository");
const generateProgramEntityObject = (requestBodyObj) => __awaiter(void 0, void 0, void 0, function* () {
    const category = yield category_repository_1.CategoryRepository.findOneBy({
        id: requestBodyObj.category_id,
        type: categoryType_enum_1.CategoryType.PROGRAM,
    });
    if (!category) {
        throw new badRequest_error_1.BadRequestError("generateProgramEntityObject-for-create-program", "Program category not found", 3015);
    }
    const program = new program_entity_1.Program();
    program.title = requestBodyObj.title;
    program.description = requestBodyObj.description;
    program.longDescription = requestBodyObj.long_description;
    program.category = category;
    program.image = requestBodyObj.image;
    program.video = requestBodyObj.video;
    program.status = requestBodyObj.status;
    program.start_date = requestBodyObj.start_date ? new Date(requestBodyObj.start_date) : null;
    if (requestBodyObj.goals && Array.isArray(requestBodyObj.goals)) {
        program.goals = requestBodyObj.goals.map((g) => {
            const goal = new programGoal_entity_1.ProgramGoal();
            goal.goal = g;
            return goal;
        });
    }
    if (requestBodyObj.achievements && Array.isArray(requestBodyObj.achievements)) {
        program.achievements = requestBodyObj.achievements.map((ach) => {
            const achievement = new programAchievement_entity_1.ProgramAchievement();
            achievement.achievement = ach;
            return achievement;
        });
    }
    if (requestBodyObj.locations && Array.isArray(requestBodyObj.locations)) {
        program.locations = requestBodyObj.locations.map((loc) => {
            const location = new programLocation_entity_1.ProgramLocation();
            location.location = loc;
            return location;
        });
    }
    return program;
});
exports.generateProgramEntityObject = generateProgramEntityObject;
const generateUpdateProgramEntityObject = (updateProgramRequestBody, program) => __awaiter(void 0, void 0, void 0, function* () {
    const category = yield category_repository_1.CategoryRepository.findOneBy({
        id: updateProgramRequestBody.category_id,
        type: categoryType_enum_1.CategoryType.PROGRAM,
    });
    if (!category) {
        throw new badRequest_error_1.BadRequestError("generateProgramEntityObject-for-create-program", "Program category not found", 3015);
    }
    program.title = updateProgramRequestBody.title;
    program.description = updateProgramRequestBody.description;
    program.longDescription = updateProgramRequestBody.long_description;
    program.image = updateProgramRequestBody.image;
    program.video = updateProgramRequestBody.video;
    program.status = updateProgramRequestBody.status;
    program.start_date = updateProgramRequestBody.start_date
        ? new Date(updateProgramRequestBody.start_date)
        : program.start_date;
    if (updateProgramRequestBody.goals) {
        yield programGoal_repository_1.ProgramGoalRepository.delete({ program: program });
        program.goals = updateProgramRequestBody.goals.map((g) => {
            const goal = new programGoal_entity_1.ProgramGoal();
            goal.goal = g;
            goal.program = program;
            return goal;
        });
    }
    if (updateProgramRequestBody.achievements) {
        yield programAchievement_repository_1.ProgramAchivementRepository.delete({ program: program });
        program.achievements = updateProgramRequestBody.achievements.map((ach) => {
            const achievement = new programAchievement_entity_1.ProgramAchievement();
            achievement.achievement = ach;
            achievement.program = program;
            return achievement;
        });
    }
    if (updateProgramRequestBody.locations) {
        yield programLocation_repository_1.ProgramLocationRepository.delete({ program: program });
        program.locations = updateProgramRequestBody.locations.map((loc) => {
            const location = new programLocation_entity_1.ProgramLocation();
            location.location = loc;
            location.program = program;
            return location;
        });
    }
    return program;
});
exports.generateUpdateProgramEntityObject = generateUpdateProgramEntityObject;
//# sourceMappingURL=program.utility.js.map