"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateUpdatedStoryEntityObject = exports.generateStoryEntityObject = void 0;
const story_entity_1 = require("../entities/story.entity");
const categoryType_enum_1 = require("../enums/categoryType.enum");
const badRequest_error_1 = require("../errors/badRequest.error");
const category_repository_1 = require("../repositories/category.repository");
const generateStoryEntityObject = (requestBodyObj) => __awaiter(void 0, void 0, void 0, function* () {
    const category = yield category_repository_1.CategoryRepository.findOneBy({
        id: requestBodyObj.category_id,
        type: categoryType_enum_1.CategoryType.STORY,
    });
    if (!category) {
        throw new badRequest_error_1.BadRequestError("generateStoryEntityObject-for-create-story", "Story category not found", 3015);
    }
    const story = new story_entity_1.Story();
    story.title = requestBodyObj.title;
    story.excerpt = requestBodyObj.excerpt;
    story.content = requestBodyObj.content;
    story.image = requestBodyObj.image;
    story.video = requestBodyObj.video;
    story.createdBy = requestBodyObj.current_user;
    story.category = category;
    story.location = requestBodyObj.location;
    return story;
});
exports.generateStoryEntityObject = generateStoryEntityObject;
const generateUpdatedStoryEntityObject = (updatedRequestBody, story) => __awaiter(void 0, void 0, void 0, function* () {
    const category = yield category_repository_1.CategoryRepository.findOneBy({
        id: updatedRequestBody.category_id,
        type: categoryType_enum_1.CategoryType.STORY,
    });
    if (!category) {
        throw new badRequest_error_1.BadRequestError("generateUpdatedStoryEntityObject-for-create-story", "Story category not found", 3015);
    }
    story.title = updatedRequestBody.title;
    story.excerpt = updatedRequestBody.excerpt;
    story.content = updatedRequestBody.content;
    story.image = updatedRequestBody.image;
    story.video = updatedRequestBody.video;
    story.category = category;
    story.location = updatedRequestBody.location;
    return story;
});
exports.generateUpdatedStoryEntityObject = generateUpdatedStoryEntityObject;
//# sourceMappingURL=story.utility.js.map