"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResetPasswordRequestBody = exports.ForgotPasswordRequestBody = exports.ChangePasswordRequestBody = exports.SignInRequestBody = exports.SignupRequestBody = void 0;
const joi_1 = __importDefault(require("joi"));
exports.SignupRequestBody = joi_1.default.object({
    email: joi_1.default.string().email().max(200).required(),
    username: joi_1.default.string().max(200).required(),
});
exports.SignInRequestBody = joi_1.default.object({
    email: joi_1.default.string().email().max(200).required(),
    password: joi_1.default.string().min(8).max(200).required(),
});
exports.ChangePasswordRequestBody = joi_1.default.object({
    oldPassword: joi_1.default.string().min(8).max(200).required(),
    newPassword: joi_1.default.string().min(8).max(200).required(),
});
exports.ForgotPasswordRequestBody = joi_1.default.object({
    email: joi_1.default.string().email().max(200).required(),
});
exports.ResetPasswordRequestBody = joi_1.default.object({
    email: joi_1.default.string().email().max(200).required(),
    temp_pass: joi_1.default.string().min(8).max(200).required(),
});
//# sourceMappingURL=authRequestBody.validator.js.map