"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateProgramRequestBody = void 0;
const joi_1 = __importDefault(require("joi"));
const programStatus_enum_1 = require("../enums/programStatus.enum");
exports.CreateProgramRequestBody = joi_1.default.object({
    title: joi_1.default.string().max(400).required(),
    description: joi_1.default.string().required(),
    long_description: joi_1.default.string().required(),
    category_id: joi_1.default.number().positive().required(),
    goals: joi_1.default.array().items(joi_1.default.string().min(5).max(500).required()).min(1).required().messages({
        "array.min": "At least one goal is required.",
        "any.required": "Goals are required.",
    }),
    achievements: joi_1.default.array()
        .items(joi_1.default.string().min(5).max(500).required())
        .min(1)
        .required()
        .messages({
        "array.min": "At least one achievement is required.",
    }),
    locations: joi_1.default.array()
        .items(joi_1.default.string().min(3).max(255).required())
        .min(1)
        .required()
        .messages({
        "array.min": "At least one location is required.",
    }),
    status: joi_1.default.string()
        .valid(programStatus_enum_1.ProgramStatus.PROPOSED, programStatus_enum_1.ProgramStatus.ONGOING, programStatus_enum_1.ProgramStatus.COMPLETED)
        .required(),
    video: joi_1.default.string().optional().allow(""),
    start_date: joi_1.default.date().optional().allow(null),
});
//# sourceMappingURL=programRequestBody.validator.js.map