import { User } from "../entities/user.entity";
import { TokenProviderResponse } from "../interfaces/tokenProviderResponse.interface";
export declare const sanitizeLoginTokenResponse: (tokenResponse: TokenProviderResponse) => {
    access: string;
    refresh: string;
};
/**
 * * Validate the new password asynchronously:
 * * The password must meet the following criteria:
 * * - At least 8 characters long
 * * - Contains at least one lowercase letter
 * * - Contains at least one uppercase letter
 * * - Contains at least one special character (e.g., !@#$%^&*)
 * * - Contains at least one number
 * @function isValidPassword
 * @param {string} password - Password to be validated
 * @returns {Promise<boolean>} - Promise that resolves to true if the password is valid, false otherwise
 */
export declare const isValidPassword: (password: string) => Promise<boolean>;
/**
 * * Generate a random valid password asynchronously
 * * The password will follow the rule:
 * * at least 8 characters long, one capital letter, one small letter, one special character, one number
 * @function generateRandomValidPassword
 * @returns {Promise<string>} - Randomly generated valid password
 */
export declare const generateRandomValidPassword: () => Promise<string>;
export declare const generateUserEntityObject: (email: string, password: string, username: string, tempPass: string | null) => User;
//# sourceMappingURL=user.utility.d.ts.map